﻿#################################################################################
#																				#
#	Application		: AnyDesk Function Library	                                #
#	Creatorted		: Marcel Grimmeissen, Axians Cloud & IT Automation			#
#	Date			: 19.05.2025												#
#																				#
#################################################################################

#####################
# 	  Variables	    #
#####################

$productName = "AnyDesk"

#####################
# 	  Functions	    #
#####################

function Write-Log([string]$logtext, [int]$level=0) {
	$logdate = get-date -format "yyyy-MM-dd HH:mm:ss"
	if($level -eq 0)
	{
		$logtext = "[INFO] " + $logtext
		$text = "["+$logdate+"] - " + $logtext
		Write-Host -ForegroundColor Black -BackgroundColor Green $text
		$text | Out-File -FilePath ".\InstallLog.txt" -Append
	}
	if($level -eq 1)
	{
		$logtext = "[WARNING] " + $logtext
		$text = "["+$logdate+"] - " + $logtext
		Write-Host -ForegroundColor Black -BackgroundColor Yellow $text
		$text | Out-File -FilePath ".\InstallLog.txt" -Append
	}
	if($level -eq 2)
	{
		$logtext = "[ERROR] " + $logtext
		$text = "["+$logdate+"] - " + $logtext
		Write-Host -ForegroundColor Black -BackgroundColor Red $text
		$text | Out-File -FilePath ".\InstallLog.txt" -Append
	}
	$text >> $logfile
}

function InstallEXE {
    $CurDir = (Get-Location).Path + "\EXE"
    $ExeFiles = Get-ChildItem -Path $CurDir -Filter "*.EXE" | ForEach-Object { $_.FullName } | Sort-Object
    $Arguments = ' --install "C:\Program Files (x86)\AnyDesk Axians" --remove-first --create-shortcuts --silent'

    if ($ExeFiles) {
        foreach ($EXE in $ExeFiles) {
            $toexe = $EXE + $Arguments
            $Message = "Launching EXE install:" + $toexe
            Write-Log $Message 0
            cmd /c $toexe
        }
    }
    else {
        $Message = "Did not find anyting related to $productName to launch an EXE install"
        Write-Log $Message 1
    }
}

function RemoveAnyDeskSupportClient {

    $CurDir = (Get-Location).Path + "\EXE"
    $ExeFiles = Get-ChildItem -Path $CurDir -Filter "*.EXE" | ForEach-Object { $_.FullName } | Sort-Object
    $Arguments = ' --silent --remove'

    if ($ExeFiles) {
        foreach ($EXE in $ExeFiles) {
            $toexe = $EXE + $Arguments
            $Message = "Launching EXE install:" + $toexe
            Write-Log $Message 0
            cmd /c $toexe
        }
    }
    else {
        $Message = "Did not find anyting related to $productName to launch an EXE install"
        Write-Log $Message 1
    }


}